
rm(list = ls())

library("readr")
library("dplyr")
library("readxl")
library("writexl")
library("stringr")
options(scipen=999)

EMPAQUETADOS <- read.csv("../Bases de datos/EMPAQUETAMIENTO_FIJO_6.csv", sep=";", dec=",")

BD <- filter(EMPAQUETADOS, ID_SERVICIO_PAQUETE == 4)

BD <- filter(BD, !(ID_SEGMENTO %in% c(107,109,117)))

BD$FECHA <- paste(BD$ANNO, "-", BD$TRIMESTRE)
BD$FECHA <- str_replace(BD$FECHA, " - ", "-")

PERIODO <- sort(unique(BD$FECHA), decreasing = FALSE)

BD_1 <- BD %>% group_by(FECHA, ANNO, TRIMESTRE, ID_MUNICIPIO, ID_EMPRESA) %>% summarise(ACCESOS = sum(ACCESOS), .groups = 'drop') %>% as.data.frame()
BD_1$ID_EMPRESA <- ifelse(BD_1$ID_EMPRESA == "890905065", "900092385", BD_1$ID_EMPRESA)
BD_1$ID_EMPRESA <- ifelse(BD_1$ID_EMPRESA == "830114921", "900092385", BD_1$ID_EMPRESA)
BD_1 <- BD_1 %>% group_by(FECHA, ANNO, TRIMESTRE, ID_MUNICIPIO, ID_EMPRESA) %>% summarise(ACCESOS = sum(ACCESOS), .groups = 'drop') %>% as.data.frame()
BD_1 <- merge(BD_1, BD_1 %>% group_by(FECHA, ANNO, TRIMESTRE, ID_MUNICIPIO) %>% summarise(TOTAL_ACCESOS = sum(ACCESOS), .groups = 'drop') %>% as.data.frame())
BD_1$SH <- BD_1$ACCESOS / BD_1$TOTAL_ACCESOS

IHH <- as.data.frame(unique(BD[c("ID_MUNICIPIO")]))
for (i in PERIODO) {
  IHH[[i]] <- 0
}

for (j in 1:length(PERIODO)) {
  a <- filter(BD_1, FECHA == PERIODO[j])
  for (i in 1:nrow(IHH)) {
    b <- filter(a, ID_MUNICIPIO %in% IHH[i, 1])
    c <- as.numeric(b$SH %*% b$SH)
    IHH[i, j + 1] <- c
  }
}
IHH$CONCENTRADO <- ifelse(IHH$`2024-3` >= 0.3, 1, 0)
PORCENTAJE_CONCENTRADOS <- sum(IHH$CONCENTRADO)/nrow(IHH)

S_MAX <- as.data.frame(unique(BD[c("ID_MUNICIPIO")]))
S_MAX_NIT <- S_MAX
for (i in PERIODO) {
  S_MAX[[i]] <- 0
}
for (i in PERIODO) {
  S_MAX_NIT[[i]] <- 0
}

for (j in 1:length(PERIODO)) {
  a <- filter(BD_1, FECHA == PERIODO[j])
  for (i in 1:nrow(S_MAX)) {
    b <- filter(a, ID_MUNICIPIO %in% S_MAX[i, 1])
    b <- arrange(b, -SH)
    c <- as.numeric(b$SH[1])
    d <- as.numeric(b$ID_EMPRESA[1])
    S_MAX[i, j + 1] <- c
    S_MAX_NIT[i, j + 1] <- d
  }
}
S_MAX_NIT$TIGO <- ifelse(S_MAX_NIT$`2024-3` == 900092385, 1, 0)
S_MAX_NIT$MOVISTAR <- ifelse(S_MAX_NIT$`2024-3` == 830122566, 1, 0)

MUNICIPIOS <- select(IHH, ID_MUNICIPIO, `2024-3`)
colnames(MUNICIPIOS)[2] <- "IHH_PREVIO"
MUNICIPIOS <- merge(MUNICIPIOS, select(S_MAX, ID_MUNICIPIO, `2024-3`), by = "ID_MUNICIPIO", sort = FALSE, all.x = TRUE)
colnames(MUNICIPIOS)[3] <- "S_MAX_PREVIO"
MUNICIPIOS <- merge(MUNICIPIOS, select(S_MAX_NIT, ID_MUNICIPIO, `2024-3`, TIGO, MOVISTAR), by = "ID_MUNICIPIO", sort = FALSE, all.x = TRUE)
colnames(MUNICIPIOS)[4] <- "NIT_PREVIO"

BD_2 <- BD_1
BD_2$ID_EMPRESA <- ifelse(BD_2$ID_EMPRESA == "830122566", "900092385", BD_2$ID_EMPRESA)
BD_2 <- BD_2 %>% group_by(FECHA, ANNO, TRIMESTRE, ID_MUNICIPIO, ID_EMPRESA) %>% summarise(ACCESOS = sum(ACCESOS), .groups = 'drop') %>% as.data.frame()
BD_2 <- merge(BD_2, BD_2 %>% group_by(FECHA, ANNO, TRIMESTRE, ID_MUNICIPIO) %>% summarise(TOTAL_ACCESOS = sum(ACCESOS), .groups = 'drop') %>% as.data.frame())
BD_2$SH <- BD_2$ACCESOS / BD_2$TOTAL_ACCESOS

IHH <- as.data.frame(unique(BD[c("ID_MUNICIPIO")]))
for (i in PERIODO) {
  IHH[[i]] <- 0
}

for (j in 1:length(PERIODO)) {
  a <- filter(BD_2, FECHA == PERIODO[j])
  for (i in 1:nrow(IHH)) {
    b <- filter(a, ID_MUNICIPIO %in% IHH[i, 1])
    c <- as.numeric(b$SH %*% b$SH)
    IHH[i, j + 1] <- c
  }
}
IHH$CONCENTRADO <- ifelse(IHH$`2024-3` >= 0.3, 1, 0)

S_MAX <- as.data.frame(unique(BD[c("ID_MUNICIPIO")]))
S_MAX_NIT <- S_MAX
for (i in PERIODO) {
  S_MAX[[i]] <- 0
}
for (i in PERIODO) {
  S_MAX_NIT[[i]] <- 0
}

for (j in 1:length(PERIODO)) {
  a <- filter(BD_2, FECHA == PERIODO[j])
  for (i in 1:nrow(S_MAX)) {
    b <- filter(a, ID_MUNICIPIO %in% S_MAX[i, 1])
    b <- arrange(b, -SH)
    c <- as.numeric(b$SH[1])
    d <- as.numeric(b$ID_EMPRESA[1])
    S_MAX[i, j + 1] <- c
    S_MAX_NIT[i, j + 1] <- d
  }
}
S_MAX_NIT$INTEGRACION <- ifelse(S_MAX_NIT$`2024-3` == 900092385, 1, 0)

MUNICIPIOS <- merge(MUNICIPIOS, select(IHH, ID_MUNICIPIO, `2024-3`), by = "ID_MUNICIPIO", sort = FALSE, all.x = TRUE)
colnames(MUNICIPIOS)[7] <- "IHH_POSTERIOR"
MUNICIPIOS <- merge(MUNICIPIOS, select(S_MAX, ID_MUNICIPIO, `2024-3`), by = "ID_MUNICIPIO", sort = FALSE, all.x = TRUE)
colnames(MUNICIPIOS)[8] <- "S_MAX_POSTERIOR"
MUNICIPIOS <- merge(MUNICIPIOS, select(S_MAX_NIT, ID_MUNICIPIO, `2024-3`, INTEGRACION), by = "ID_MUNICIPIO", sort = FALSE, all.x = TRUE)
colnames(MUNICIPIOS)[9] <- "NIT_POSTERIOR"

MUNICIPIOS$AFECTADO <- round(MUNICIPIOS$IHH_POSTERIOR - MUNICIPIOS$IHH_PREVIO, 6)

MONOPOLIOS_PREVIO <- sum(MUNICIPIOS$IHH_PREVIO == 1, na.rm = TRUE)
MONOPOLIOS_VIRTUALES_PREVIO <- sum(MUNICIPIOS$S_MAX_PREVIO > 0.9, na.rm = TRUE)
AFECTADOS <- sum(MUNICIPIOS$AFECTADO > 0, na.rm = TRUE)
MONOPOLIOS_POSTERIOR <- sum(MUNICIPIOS$IHH_POSTERIOR == 1, na.rm = TRUE)
MONOPOLIOS_VIRTUALES_POSTERIOR <- sum(MUNICIPIOS$S_MAX_POSTERIOR > 0.9, na.rm = TRUE)
PORCENTAJE_CONCENTRADOS_2 <- sum(IHH$CONCENTRADO)/nrow(IHH)
L_TIGO <- sum(MUNICIPIOS$TIGO, na.rm = TRUE)
L_MOVISTAR <- sum(MUNICIPIOS$MOVISTAR, na.rm = TRUE)
L_INTEGRACION <- sum(MUNICIPIOS$INTEGRACION, na.rm = TRUE)

write_xlsx(MUNICIPIOS, "a. 2PLAY1.xlsx")
